jQuery(function(jQuery) {
	
	
	jQuery('#media-items').bind('DOMNodeInserted',function(){
		jQuery('input[value="Insert into Post"]').each(function(){
				jQuery(this).attr('value','Use This Image');
		});
	});
	
	jQuery('.custom_upload_image_button').live("click",function() {
		formfield = jQuery(this).siblings('.custom_upload_image');
		preview = jQuery(this).siblings('.custom_preview_image');
		tb_show('', 'media-upload.php?type=image&TB_iframe=true');
		window.send_to_editor = function(html) {
			imgurl = jQuery('img',html).attr('src');
			classes = jQuery('img', html).attr('class');
			imgsize = jQuery('img', html).css('max-width','100%');
			id = classes.replace(/(.*?)wp-image-/, '');
			formfield.val(id);
			preview.attr('src', imgurl);
			tb_remove();
		}
		return false;
	});
	
	jQuery('.custom_clear_image_button').click(function() {
		var defaultImage = jQuery(this).parent().siblings('.custom_default_image').text();
		jQuery(this).closest("td").find('.custom_upload_image').val('');
		
		jQuery(this).closest("td").find('.custom_preview_image').replaceWith('<img src="" class="custom_preview_image" style="max-width:100%" alt="">');
		return false;
	});
			 
	jQuery('.repeatable-add').click(function() {
		fieldLocation = jQuery(this).closest('td').find('.custom_repeatable li:last');
		field = fieldLocation.clone(true,true);
		
		jQuery('input,textarea', field).each(function(){
			jQuery(this).val('').attr('name', function(index, name) {
				return name.replace(/(\d+)/, function(fullMatch, n) {
					return Number(n) + 1;
				});
			});

		});
		field.insertAfter(fieldLocation);
		return false;
	});

	jQuery('.repeatable-add-image').click(function() {
		fieldLocation = jQuery(this).closest('td').find('.custom_repeatable li:last');
		field = fieldLocation.clone(true,true);
		jQuery('.custom_upload_image',field).val("");
		jQuery('.custom_preview_image',field).attr("src","");
		jQuery('input,textarea', field).each(function(){
			jQuery(this).attr('name', function(index, name) {
				if(name && !jQuery(this).hasClass("button")){
					jQuery(this).val("");
					return name.replace(/(\d+)/, function(fullMatch, n) {
						return Number(n) + 1;
					});
				}

			});

		});
		field.insertAfter(fieldLocation);
		return false;
	});
	
	jQuery('.repeatable-remove').click(function(){
		jQuery(this).parent().parent().remove();
		return false;
	});

	
		
	jQuery('.custom_repeatable').sortable({
		opacity: 0.6,
		revert: true,
		cursor: 'move',
		handle: '.sort',
		stop: function(event, ui) { 
			jQuery('.custom_repeatable').each(function(){
				field_count=0;
				jQuery(this).find("li").each(function(){
					jQuery(this).find("input,textarea").each(function(){
						$this = jQuery(this);
						name_array=($this.attr("name")).split("[");
						$this.attr("name",name_array[0]+"["+field_count+"]");
					});
					field_count++;
				});
			});
		}
	});

});